<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Shipping extends Model 
{

    protected $table = 'shippings';
    public $timestamps = true;
    protected $fillable = array('client_id', 'governorate_id', 'address', 'zip_code', 'phone');

    public function client()
    {
        return $this->belongsTo('App\Models\Client');
    }

    public function governorate()
    {
        return $this->belongsTo('App\Models\Governorate');
    }

    public function orders()
    {
        return $this->belongsTo('App\Models\Order');
    }

}